export default {
  // Navigation
  nav: {
    home: 'Accueil',
    about: 'À Propos',
    services: 'Services',
    news: 'Actualités',
    contact: 'Contact'
  },

  // Common
  common: {
    siteTitle: 'Advensys Insurance Finance',
    getQuote: 'Obtenir un Devis',
    learnMore: 'En Savoir Plus',
    contactUs: 'Nous Contacter',
    readMore: 'Lire Plus',
    submit: 'Soumettre',
    send: 'Envoyer',
    loading: 'Chargement...',
    error: 'Erreur',
    success: 'Succès',
    close: 'Fermer',
    back: 'Retour',
    next: 'Suivant',
    previous: 'Précédent',
    yes: 'Oui',
    no: 'Non',
    save: 'Enregistrer',
    cancel: 'Annuler',
    edit: 'Modifier',
    delete: 'Supprimer',
    view: 'Voir',
    download: 'Télécharger'
  },

  // Header
  header: {
    languageSwitcher: 'Changer de Langue',
    locationSwitcher: 'Sélectionner l\'Emplacement',
    phone: 'Téléphone',
    email: 'Email'
  },

  // Hero Section
  hero: {
    slide1: {
      subtitle: 'Protégez Votre Avenir Aujourd\'hui',
      title: 'Solutions d\'Assurance Complètes',
      description: 'Obtenez une couverture d\'assurance personnalisée qui correspond à vos besoins uniques et à votre budget. Notre équipe d\'experts offre des solutions complètes pour les particuliers et les entreprises.',
      cta: 'Devis Gratuit'
    },
    slide2: {
      subtitle: 'Sécurisez Votre Avenir',
      title: 'Excellence en Planification Financière',
      description: 'Services de planification financière professionnelle pour vous aider à atteindre vos objectifs. De la planification de retraite aux stratégies d\'investissement, nous vous couvrons.',
      cta: 'En Savoir Plus'
    },
    slide3: {
      subtitle: 'Faites Confiance aux Professionnels',
      title: 'Conseils d\'Assurance Experts',
      description: 'Avec des années d\'expérience dans l\'industrie de l\'assurance, nos professionnels certifiés fournissent des conseils experts pour tous vos besoins d\'assurance.',
      cta: 'Nous Contacter'
    },
    features: {
      fastService: 'Service Rapide',
      expertAdvice: 'Conseils d\'Expert',
      bestRates: 'Meilleurs Tarifs'
    },
    stats: {
      clients: 'Clients Satisfaits',
      experience: 'Années d\'Expérience',
      partners: 'Partenaires d\'Assurance'
    }
  },

  // Services Section
  services: {
    title: 'Nos Services d\'Assurance',
    subtitle: 'Solutions d\'assurance complètes adaptées pour protéger ce qui compte le plus pour vous',
    description: 'Nous offrons une large gamme de services d\'assurance et financiers pour protéger ce qui compte le plus pour vous.',
    cta: {
      title: 'Besoin d\'Aide pour Choisir la Bonne Couverture ?',
      description: 'Nos experts en assurance sont là pour vous aider à trouver la couverture parfaite pour vos besoins et votre budget.',
      button: 'Consultation Gratuite',
      phone: 'Appelez :'
    },
    items: {
      autoInsurance: {
        title: 'Assurance Auto',
        description: 'Couverture complète pour vos véhicules avec des tarifs compétitifs et un excellent service client.',
        features: ['Couverture Collision', 'Protection Responsabilité', 'Support Réclamations 24/7', 'Assistance Routière']
      },
      healthInsurance: {
        title: 'Assurance Santé',
        description: 'Protégez votre santé et vos finances avec notre gamme de plans d\'assurance médicale.',
        features: ['Couverture Médicale', 'Médicaments sur Ordonnance', 'Soins Préventifs', 'Services d\'Urgence']
      },
      lifeInsurance: {
        title: 'Assurance Vie',
        description: 'Sécurisez l\'avenir financier de votre famille avec nos polices d\'assurance vie.',
        features: ['Assurance Vie Temporaire', 'Assurance Vie Entière', 'Assurance Vie Universelle', 'Options d\'Investissement']
      },
      businessInsurance: {
        title: 'Assurance Entreprise',
        description: 'Protection d\'entreprise complète incluant responsabilité, propriété et compensation des travailleurs.',
        features: ['Responsabilité Générale', 'Couverture Propriété', 'Compensation Travailleurs', 'Protection Cyber']
      },
      propertyInsurance: {
        title: 'Assurance Propriété',
        description: 'Protégez votre maison et vos biens personnels avec nos solutions d\'assurance propriété.',
        features: ['Assurance Habitation', 'Assurance Locataire', 'Couverture Copropriété', 'Biens Personnels']
      },
      financialPlanning: {
        title: 'Planification Financière',
        description: 'Services professionnels de planification financière et de conseil en investissement.',
        features: ['Planification Retraite', 'Conseils Investissement', 'Planification Fiscale', 'Planification Succession']
      }
    }
  },

  // About Section
  about: {
    title: 'À Propos d\'Advensys',
    subtitle: 'Votre Partenaire d\'Assurance de Confiance',
    description: 'Avec plus de 15 ans d\'expérience dans l\'industrie de l\'assurance, Advensys Insurance Finance fournit des solutions d\'assurance fiables et complètes aux particuliers et aux entreprises.',
    mission: {
      title: 'Notre Mission',
      description: 'Fournir des services d\'assurance et financiers exceptionnels qui protègent les actifs les plus précieux de nos clients tout en construisant des relations à long terme basées sur la confiance et la fiabilité.'
    },
    vision: {
      title: 'Notre Vision',
      description: 'Être le principal fournisseur d\'assurance de la région, reconnu pour nos solutions innovantes, notre service client exceptionnel et notre engagement envers le succès de nos clients.'
    },
    values: {
      title: 'Nos Valeurs',
      subtitle: 'Les principes qui guident tout ce que nous faisons et définissent qui nous sommes en tant qu\'entreprise.',
      integrity: 'Intégrité',
      excellence: 'Excellence',
      innovation: 'Innovation',
      service: 'Service Client',
      customerFocus: 'Focus Client',
      integrityDesc: 'Nous opérons avec honnêteté et transparence dans toutes nos transactions.',
      excellenceDesc: 'Nous visons les plus hauts standards dans tout ce que nous faisons.',
      customerFocusDesc: 'Vos besoins et votre satisfaction sont notre priorité absolue.'
    },
    achievements: {
      experience: {
        title: 'Années d\'Expérience',
        description: 'Servir les clients avec excellence'
      },
      clients: {
        title: 'Clients Satisfaits',
        description: 'Clients satisfaits à travers le pays'
      },
      partners: {
        title: 'Partenaires d\'Assurance',
        description: 'Compagnies d\'assurance de premier plan'
      },
      support: {
        title: 'Support Client',
        description: 'Toujours là quand vous avez besoin de nous'
      }
    },
    heroTitle: 'Pourquoi Choisir',
    heroTitleHighlight: 'Advensys?',
    heroDescription: 'Avec plus de 15 ans d\'expérience dans l\'industrie de l\'assurance, Advensys Insurance Finance fournit des solutions d\'assurance fiables et complètes aux particuliers et aux entreprises.',
    learnMoreBtn: 'En Savoir Plus',
    experienceBadge: 'Années d\'Expérience',
    highlights: {
      licensed: {
        title: 'Agréé',
        description: 'Professionnels entièrement agréés et certifiés'
      },
      award: {
        title: 'Primé',
        description: 'Reconnu pour l\'excellence du service'
      }
    },
    whyChoose: {
      title: 'Pourquoi Choisir Advensys?',
      expertise: {
        title: 'Expertise Professionnelle',
        description: 'Nos professionnels certifiés ont une expertise approfondie de l\'industrie pour vous guider vers les meilleures solutions.'
      },
      personalized: {
        title: 'Service Personnalisé',
        description: 'Nous prenons le temps de comprendre vos besoins uniques et fournissons des solutions d\'assurance sur mesure.'
      },
      competitive: {
        title: 'Tarifs Compétitifs',
        description: 'Nous travaillons avec les meilleurs assureurs pour vous trouver la meilleure couverture aux prix les plus compétitifs.'
      },
      support: {
        title: 'Support Continu',
        description: 'Notre relation ne se termine pas à la vente. Nous fournissons un support continu pour tous vos besoins.'
      }
    }
  },

  // News Section
  news: {
    title: 'Dernières Actualités',
    subtitle: 'Restez Informé',
    description: 'Tenez-vous au courant des dernières nouvelles et perspectives de l\'industrie de l\'assurance.',
    readMore: 'Lire l\'Article Complet',
    publishedOn: 'Publié le',
    category: 'Catégorie',
    author: 'Auteur',
    readTime: '{{minutes}} min de lecture',
    articles: {
      healthInsurance2024: {
        title: 'Comprendre les Changements d\'Assurance Santé pour 2024',
        excerpt: 'Mises à jour importantes des polices d\'assurance santé qui pourraient affecter votre couverture et vos primes.',
        category: 'Assurance Santé',
        readTime: '5 min de lecture'
      },
      autoInsuranceTips: {
        title: 'Top 5 des Conseils pour Choisir la Bonne Assurance Auto',
        excerpt: 'Conseils d\'experts pour sélectionner une assurance auto qui offre le meilleur rapport qualité-prix et protection.',
        category: 'Assurance Auto',
        readTime: '4 min de lecture'
      }
    }
  },

  // Contact Section
  contact: {
    title: 'Entrer en Contact',
    subtitle: 'Contactez-nous Aujourd\'hui',
    description: 'Prêt à commencer ? Contactez notre équipe d\'experts pour des solutions d\'assurance personnalisées.',
    form: {
      title: 'Envoyez-nous un Message',
      description: 'Remplissez le formulaire ci-dessous et nous vous répondrons dans les 24 heures.',
      firstName: 'Prénom',
      lastName: 'Nom de Famille',
      email: 'Adresse Email',
      phone: 'Numéro de Téléphone',
      service: 'Service d\'Intérêt',
      message: 'Message',
      submit: 'Envoyer le Message',
      selectService: 'Sélectionnez un service...',
      required: 'Ce champ est requis',
      invalidEmail: 'Veuillez entrer une adresse email valide',
      success: 'Merci pour votre message. Nous vous contacterons bientôt !',
      error: 'Désolé, il y a eu une erreur lors de l\'envoi de votre message. Veuillez réessayer.'
    },
    info: {
      title: 'Informations de Contact',
      description: 'Contactez-nous par l\'une de ces méthodes pratiques.',
      address: 'Adresse',
      phone: 'Téléphone',
      email: 'Email',
      workingHours: 'Heures d\'Ouverture',
      followUs: 'Suivez-nous'
    }
  },

  // Footer
  footer: {
    description: 'Votre partenaire de confiance pour des solutions d\'assurance et financières complètes. Protéger ce qui compte le plus pour vous.',
    quickLinks: {
      title: 'Liens Rapides',
      home: 'Accueil',
      about: 'À Propos',
      services: 'Services',
      news: 'Actualités',
      contact: 'Contact',
      privacy: 'Politique de Confidentialité',
      terms: 'Conditions de Service'
    },
    services: {
      title: 'Services',
      life: 'Assurance Vie',
      health: 'Assurance Santé',
      auto: 'Assurance Auto',
      home: 'Assurance Habitation',
      business: 'Assurance Entreprise'
    },
    contact: {
      title: 'Informations de Contact',
      address: 'Adresse',
      phone: 'Téléphone',
      email: 'Email',
      workingHours: 'Heures d\'Ouverture'
    },
    newsletter: {
      title: 'Newsletter',
      description: 'Abonnez-vous à notre newsletter pour les dernières mises à jour et conseils d\'assurance.',
      placeholder: 'Entrez votre email',
      subscribe: 'S\'abonner',
      success: 'Abonnement réussi !',
      error: 'Échec de l\'abonnement. Veuillez réessayer.'
    },
    copyright: '© 2024 Advensys Insurance Finance. Tous droits réservés.',
    developedBy: 'Développé par'
  },

  // Services Page
  servicesPage: {
    title: 'Nos Services d\'Assurance',
    subtitle: 'Solutions de Protection Complètes',
    description: 'Découvrez notre gamme complète de services d\'assurance conçus pour vous protéger, vous, votre famille et votre entreprise.',
    whyChooseUs: {
      title: 'Pourquoi Choisir Advensys ?',
      description: 'Nous combinons des années d\'expérience avec un service personnalisé pour offrir les meilleures solutions d\'assurance à nos clients.',
      experience: {
        title: 'Années d\'Expérience',
        description: 'Plus de 15 ans d\'expertise dans l\'industrie de l\'assurance.'
      },
      personalized: {
        title: 'Service Personnalisé',
        description: 'Solutions d\'assurance adaptées à vos besoins spécifiques.'
      },
      competitive: {
        title: 'Tarifs Compétitifs',
        description: 'Meilleurs tarifs du marché avec une couverture maximale.'
      },
      support: {
        title: 'Support 24/7',
        description: 'Support client 24h/24 pour tous vos besoins.'
      }
    },
    highlights: {
      expertAdvice: 'Conseils d\'Expert',
      competitiveRates: 'Tarifs Compétitifs',
      support: 'Support 24/7'
    },
    featuresTitle: 'Ce qui est Inclus',
    benefitsTitle: 'Pourquoi Choisir ce Service',
    auto: {
      features: {
        collision: 'Couverture Collision',
        liability: 'Protection Responsabilité',
        support: 'Support Réclamations 24/7',
        roadside: 'Assistance Routière',
        rental: 'Couverture Voiture de Location',
        glass: 'Couverture Réparation Vitres'
      },
      benefits: {
        rates: 'Tarifs compétitifs avec plusieurs rabais',
        discounts: 'Rabais conducteur prudent et multi-polices',
        rewards: 'Programmes de pardon d\'accidents',
        processing: 'Traitement des réclamations rapide et facile'
      }
    },
    health: {
      features: {
        medical: 'Couverture Médicale Complète',
        prescription: 'Avantages Médicaments sur Ordonnance',
        preventive: 'Services de Soins Préventifs',
        emergency: 'Couverture Salle d\'Urgence',
        specialist: 'Accès aux Soins Spécialisés',
        mental: 'Support Santé Mentale'
      },
      benefits: {
        network: 'Vaste réseau de fournisseurs à l\'échelle nationale',
        preventiveCost: 'Services de soins préventifs sans coût',
        flexible: 'Options flexibles de franchise et co-paiement',
        submission: 'Soumission facile de réclamations en ligne'
      }
    },
    life: {
      features: {
        term: 'Assurance Vie Temporaire',
        whole: 'Assurance Vie Entière',
        universal: 'Assurance Vie Universelle',
        investment: 'Options d\'Investissement',
        living: 'Avantages de Vie',
        flexible: 'Plans de Paiement Flexibles'
      },
      benefits: {
        security: 'Sécurité financière pour les proches',
        savings: 'Épargne avec avantages fiscaux',
        coverage: 'Montants de couverture flexibles',
        exam: 'Options sans examen médical disponibles'
      }
    },
    business: {
      features: {
        liability: 'Assurance Responsabilité Générale',
        property: 'Couverture Propriété',
        workers: 'Compensation des Travailleurs',
        cyber: 'Protection Cyber Responsabilité',
        professional: 'Indemnité Professionnelle',
        interruption: 'Interruption d\'Affaires'
      },
      benefits: {
        tailored: 'Couverture adaptée à votre industrie',
        expertise: 'Expertise en gestion des risques',
        rates: 'Tarifs d\'affaires compétitifs',
        specialists: 'Spécialistes d\'affaires dédiés'
      }
    },
    property: {
      features: {
        homeowners: 'Assurance Propriétaire',
        renters: 'Assurance Locataire',
        condo: 'Couverture Copropriété',
        personal: 'Protection Biens Personnels',
        liability: 'Couverture Responsabilité',
        expenses: 'Frais de Subsistance Additionnels'
      },
      benefits: {
        replacement: 'Couverture coût de remplacement',
        discounts: 'Multiples opportunités de rabais',
        belongings: 'Protection biens personnels',
        housing: 'Assistance logement temporaire'
      }
    },
    financial: {
      features: {
        retirement: 'Planification Retraite',
        investment: 'Conseil en Investissement',
        tax: 'Stratégies Planification Fiscale',
        estate: 'Planification Succession',
        education: 'Financement Éducation',
        risk: 'Évaluation des Risques'
      },
      benefits: {
        planners: 'Planificateurs financiers certifiés',
        strategies: 'Stratégies personnalisées',
        reviews: 'Révisions régulières de portefeuille',
        readiness: 'Analyse préparation retraite'
      }
    },
    cta: {
      title: 'Prêt à Être Protégé ?',
      description: 'Contactez-nous aujourd\'hui pour une consultation gratuite et un devis personnalisé. Nos experts en assurance sont là pour vous aider à trouver la couverture parfaite.',
      button: 'Devis Gratuit',
      phone: 'Appelez : +1 (234) 567-890'
    }
  },

  // About Page
  aboutPage: {
    title: 'À Propos d\'Advensys Insurance Finance',
    subtitle: 'Votre Partenaire d\'Assurance de Confiance Depuis 2008',
    intro: 'Advensys Insurance Finance est un fournisseur leader de solutions d\'assurance complètes depuis plus de 15 ans. Nous nous engageons à protéger ce qui compte le plus pour nos clients grâce à des produits d\'assurance innovants et un service client exceptionnel.',
    ourStory: {
      title: 'Notre Histoire',
      paragraph1: 'Fondée en 2008, Advensys Insurance Finance a commencé avec une mission simple : fournir des solutions d\'assurance fiables et abordables aux particuliers et aux entreprises à travers le pays.',
      paragraph2: 'Au fil des années, nous avons établi des relations solides avec les principales compagnies d\'assurance, nous permettant d\'offrir des options de couverture complètes à des tarifs compétitifs. Notre engagement envers l\'excellence et la satisfaction client a fait de nous un nom de confiance dans l\'industrie de l\'assurance.',
      paragraph3: 'Aujourd\'hui, nous servons des milliers de clients satisfaits à travers le pays, des particuliers recherchant une protection personnelle aux entreprises nécessitant une couverture commerciale complète. Notre équipe expérimentée continue de s\'adapter aux besoins changeants du marché tout en maintenant nos valeurs fondamentales d\'intégrité, de service et de fiabilité.'
    },
    ourValues: {
      description: 'Nous croyons en la conduite des affaires avec les plus hauts standards éthiques, en mettant toujours les besoins de nos clients en premier, et en améliorant continuellement nos services pour dépasser les attentes.'
    },
    team: {
      title: 'Notre Équipe de Direction',
      subtitle: 'Rencontrez les professionnels dédiés à votre succès',
      ceo: {
        name: 'John Smith',
        position: 'PDG et Fondateur',
        bio: 'Avec plus de 20 ans d\'expérience dans l\'industrie de l\'assurance, John a fondé Advensys avec une vision de révolutionner la façon dont les services d\'assurance sont livrés aux clients.'
      },
      director: {
        name: 'Sarah Johnson',
        position: 'Directrice des Opérations',
        bio: 'Sarah apporte 15 ans d\'excellence opérationnelle à notre équipe, garantissant des processus fluides et une expérience client exceptionnelle à tous les points de contact.'
      }
    },
    licenses: {
      title: 'Licences et Certifications',
      description: 'Nous maintenons toutes les licences et certifications nécessaires pour fournir des services d\'assurance dans plusieurs états, garantissant la conformité avec les réglementations et standards de l\'industrie.',
      items: {
        stateLicensed: 'Agents Agréés par l\'État',
        certified: 'Professionnels Certifiés de l\'Industrie',
        bonded: 'Opérations Cautionnées et Assurées',
        accredited: 'Accrédité par le Better Business Bureau'
      }
    }
  },

  // Contact Page
  contactPage: {
    title: 'Contacter Advensys Insurance Finance',
    subtitle: 'Obtenez des Conseils d\'Assurance Experts Aujourd\'hui',
    description: 'Notre équipe d\'experts en assurance est prête à vous aider à trouver la couverture parfaite pour vos besoins. Contactez-nous aujourd\'hui pour une consultation et un devis gratuits.',
    locations: {
      title: 'Nos Emplacements',
      visitUs: 'Visitez-nous',
      callUs: 'Appelez-nous',
      emailUs: 'Envoyez-nous un Email'
    },
    officeHours: {
      title: 'Heures d\'Ouverture',
      weekdays: 'Lundi - Vendredi',
      weekdaysTime: '9h00 - 18h00',
      saturday: 'Samedi',
      saturdayTime: '10h00 - 16h00',
      sunday: 'Dimanche',
      closed: 'Fermé',
      emergency: 'Support d\'Urgence',
      available247: 'Disponible 24/7'
    }
  },

  // News Page
  newsPage: {
    title: 'Actualités et Perspectives sur l\'Assurance',
    subtitle: 'Restez Informé avec les Dernières Mises à Jour de l\'Industrie',
    description: 'Tenez-vous au courant des derniers développements de l\'industrie de l\'assurance, des conseils d\'experts et des nouvelles de l\'entreprise.',
    categories: {
      all: 'Toutes les Actualités',
      health: 'Assurance Santé',
      auto: 'Assurance Auto',
      life: 'Assurance Vie',
      business: 'Assurance Entreprise',
      property: 'Assurance Propriété'
    },
    filterByCategory: 'Filtrer par Catégorie',
    readTime: '{{minutes}} min de lecture',
    byAuthor: 'Par {{author}}',
    searchPlaceholder: 'Rechercher des articles...',
    noResults: 'Aucun article trouvé correspondant à votre recherche.',
    loadMore: 'Charger Plus d\'Articles',
    newsletter: {
      title: 'Restez à Jour',
      description: 'Abonnez-vous à notre newsletter pour recevoir les dernières nouvelles d\'assurance, conseils et mises à jour directement dans votre boîte de réception.',
      placeholder: 'Entrez votre adresse email',
      subscribe: 'S\'abonner'
    },
    articles: {
      healthChanges: {
        title: 'Changements 2024 de l\'Assurance Santé que Vous Devez Connaître',
        excerpt: 'Mises à jour importantes des réglementations sur l\'assurance santé et ce qu\'elles signifient pour vos options de couverture cette année.',
        author: 'Dr. Emily Wilson'
      },
      autoTips: {
        title: 'Top 5 des Façons de Réduire Votre Prime d\'Assurance Auto',
        excerpt: 'Découvrez des stratégies éprouvées pour réduire vos coûts d\'assurance auto sans sacrifier la qualité de la couverture.',
        author: 'Mark Thompson'
      },
      lifeFamilies: {
        title: 'Planification d\'Assurance Vie pour les Familles Grandissantes',
        excerpt: 'Considérations essentielles pour l\'assurance vie lors de l\'agrandissement de votre famille et la planification de l\'avenir.',
        author: 'Sarah Davis'
      },
      businessTips: {
        title: 'Assurance Petite Entreprise : Guide de Couverture Essentielle',
        excerpt: 'Guide complet pour protéger votre petite entreprise avec les bonnes options de couverture d\'assurance.',
        author: 'James Miller'
      }
    }
  }
}